/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.plugin;

import java.util.Iterator;
import java.util.Vector;
import replicatorg.app.GCode;
import replicatorg.model.GCodeSource;
import replicatorg.plugin.MCodePlugin;
import replicatorg.plugin.PluginEntry;

public class PluginEngine
implements GCodeSource {
    GCodeSource parent = null;
    Vector<PluginEntry> plugins;

    void setParentSource(GCodeSource parent) {
        this.parent = parent;
    }

    void setPlugins(Vector<PluginEntry> plugins) {
        this.plugins = plugins;
    }

    @Override
    public int getLineCount() {
        return this.parent.getLineCount();
    }

    private void processLine(String line) {
        GCode mcode = new GCode(line);
        if (mcode.hasCode('M')) {
            double code = mcode.getCodeValue('M');
            for (PluginEntry plugin : this.plugins) {
                int[] codes;
                if (!(plugin instanceof MCodePlugin)) continue;
                MCodePlugin mcp = (MCodePlugin)((Object)plugin);
                int[] nArray = codes = mcp.getAcceptedMCodes();
                int n = codes.length;
                int n2 = 0;
                while (n2 < n) {
                    int acceptedCode = nArray[n2];
                    if (code == (double)acceptedCode) {
                        mcp.processMCode(mcode);
                    }
                    ++n2;
                }
            }
        }
    }

    @Override
    public Iterator<String> iterator() {
        return new GCodeIterator(this.parent.iterator());
    }

    class GCodeIterator
    implements Iterator<String> {
        private Iterator<String> parent;

        public GCodeIterator(Iterator<String> parent) {
            this.parent = parent;
        }

        @Override
        public boolean hasNext() {
            return this.parent.hasNext();
        }

        @Override
        public String next() {
            String next = this.parent.next();
            PluginEngine.this.processLine(next);
            return next;
        }

        @Override
        public void remove() {
            this.parent.remove();
        }
    }
}

